 /***********************************************
 *
 *  DESCRIPTION: Atomic Model Processor
 *
 *  AUTHOR: Misagh Tavanpour
 *
 *  DATE: 10/12/2012
 *
 ***********************************************/

 #include "processor1.h"
 #include "message.h"       // InternalMessage ....
 #include <iostream>
 #include <fstream>
 ofstream UPI1 ("UE1PIn.txt");
 ofstream UPO1 ("UE1POut.txt");   //If this UE is a sender activate this line.
 ofstream UEM1 ("UE1PMode.txt");

 processor1::processor1( const std::string &name ) : Atomic( name )
 , In( addInputPort( "In" ) )
 , Req( addInputPort( "Req" ) )
 , Out( addInputPort( "Out" ) )
 , ProcessTime (00,00,00,02)
 , GenerateTime(00,00,00,20)
 {
 }

 Model &processor1::initFunction()
  {
    state = AskNewTask;	// waiting for new task
    Temp = 1;  //for the first time to ask new task from queue
    Mode = 0;
    RandCounter = 0;
    ServingBS = 2;
    SentPacketNum = 1;
    holdIn(Atomic::active, 0);  //Programmed to have an instantaneous internal transition.
	return *this ;
  }

 Model &processor1::externalFunction( const ExternalMessage &msg )
 { UPI1 << msg.time()<<" "<<msg.value()<<"\n";
   Temp = msg.value();    //Depart input message for future use.
   for (i=0;i<6;i++)
   {
	 Digit [i] = Temp % 10;
 	 Temp = Temp / 10;
   }

   if (Digit [3] == 0) //It is a Data packet. Send ACK for this packet to Source UE.
   {
 	 state = RecPack;
 	 Temp = Digit [4] * 10;     //Receiver in ACK pack will be sender and vice versa.
 	 Temp = Temp + Digit [5];
 	 Temp = Temp * 10 + 1;      //Make it ACK pack.
 	 for (i=2;i>=0;i--) Temp = Temp * 10 + Digit [i];  //Add Packet Number to ACK message.
 	 OutPort = ServingBS;
   }

   if (Digit [3] == 1 ) //It is a ACK packet.
   {
	 state = RecACK;
	 //Do nothing for time being.
   }

   if (Digit [3] == 2 ) //It is a BS to UE message. //Do nothing for time being.
   {
	 state = AskNewTask;
	 Temp = 1;
   }
   holdIn(Atomic::active, ProcessTime);
   return *this;
 }

 Model &processor1::outputFunction( const InternalMessage &msg )
 {
   if ((state == RecPack) || (state == SendPack) || (state == UEMode))
   {
	 sendOutput( msg.time(), Out, Temp) ;
	 if (state == SendPack) UPO1 << msg.time()<<" "<<OutPort<<" "<<Temp<<"\n";
	 if (state == UEMode)   UEM1 << msg.time()<<" "<<OutPort<<" "<<Temp<<"\n";
   }

   if (state == AskNewTask) sendOutput( msg.time(),Req, Temp) ;
   return *this ;
 }

 Model &processor1::internalFunction( const InternalMessage & )
 {
   switch (state){
	   		       case Idle:
						      //Following lines should be active if this UE wants to send Data for other UEs.(Default is for UE2)
						      //Because this is UE0 so src should be 0 which means that 02abcd --> 2abcd
						      Temp = 120000 + SentPacketNum;  // Src = 1 , Des = 2 --> 020000 --> 20000
						      state = SendPack;
						      OutPort = ServingBS;
						      holdIn( Atomic::active, GenerateTime);
					          //passivate();
					    	  break;

			       case RecPack:
					    	     ReceivedPacketNum ++;
					    	     //RandCounter ++;
					    	     //if (RandCounter == 2) //The current receiving Mode will be save for next 100 packets.
					    	     //{
					    	     //  state = UEMode;
					    	     //  Mode = rand() % 2;
					    	     //  RandCounter = 0;
					    	     // OutPort = ServingBS;
					    	     //  if (Mode == 1) Temp = 113610;  //UEnumber + 1 --> for mentioning specific UE.
					    	     //     else Temp = 103000;
					    	     //}
					    	      // else
					    	    	//   {
					    	    	     state = AskNewTask;
					    	    	     Temp = 1;
					    	    	//   }
						         break;

				   case RecACK:
					            state = AskNewTask;
					            Temp = 1;
						        break;

				   case SendPack:
				    		      SentPacketNum ++;
				    		      state = Idle;
						          break;

				   case AskNewTask:
					                state = Idle;
					                break;

				   case UEMode:
					            state = AskNewTask;
					            break;
	        		  }
    return *this;
 }

 processor1::~processor1()
{
}
